// Digit RealTime TLH.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

// For printf
#include <stdio.h>

// For light converting
#include <math.h>

// For the LabJackM Library
#include "C:\Program Files (x86)\LabJack\Drivers\LabJackM.h"

// For LabJackM helper functions
#include "C:\Users\Caleb\Documents\Visual Studio 2008\Projects\LabJackM-1.0701-examples\LJM_Utilities.h"

// For converting raw light readings
#include ".\LightCalibration.h"

void ConvertRawTemperatureC(double *TvalueC, double RawTemp);
double ReturnFfromC(double degC);
void ConvertRawHumidity(double *HvalPercentRH, double RawCapacitance, double CalOffsetH, double Hslope, double TslopeH, double TvalC);
void ConvertRawLight(double *Lux, double RawLight, double CurrentdegreesC, int OnUSBPower);

inline double Interpolate(double a, double b, double coefficient);

int _tmain(int argc, _TCHAR* argv[])
{
	int err, handle;
    double RawT = 0;
	double TvalC = 0;
    double TvalF = 0;

    double RawH, CalOffsetH, Hslope, TslopeH = 0;
    double HvalPercentRH = 0;

    double RawL = 0;
    double LvalLux = 0;

	//const char * NAME = {"DGT_TEMPERATURE_LATEST_RAW"};

	EnableLoggingLevel(LJM_TRACE);

	// Open first found USB Digit-TL/TLH 
	err = LJM_Open(LJM_dtDIGIT, LJM_ctUSB, "LJM_idANY", &handle);
	ErrorCheck(err, "LJM_Open");

	PrintDeviceInfoFromHandle(handle);

	printf("\n");
	WaitForUser();

    // Get raw temperature
    err = LJM_eReadName(handle, "DGT_TEMPERATURE_LATEST_RAW", &RawT);
	ErrorCheck(err, "LJM_eReadName");

    // Get raw humidity
    err = LJM_eReadName(handle, "DGT_HUMIDITY_RAW", &RawH);
	ErrorCheck(err, "LJM_eReadName");

    // Get calibration offset for humidity
    err = LJM_eReadName(handle, "DGT_HUMIDITY_CAL_OFFSET", &CalOffsetH);
	ErrorCheck(err, "LJM_eReadName");

    // Get calibration slope for humidity
    err = LJM_eReadName(handle, "DGT_HUMIDITY_CAL_SLOPE", &Hslope);
	ErrorCheck(err, "LJM_eReadName");

    // Get calibration temperature dependent slope for humidity
    err = LJM_eReadName(handle, "DGT_HUMIDITY_CAL_T_SLOPE", &TslopeH);
	ErrorCheck(err, "LJM_eReadName");

    // Get raw light
    err = LJM_eReadName(handle, "DGT_LIGHT_RAW", &RawL);
	ErrorCheck(err, "LJM_eReadName");

	// Print raw results
	printf("%s: %f\n", "DGT_TEMPERATURE_LATEST_RAW", RawT);
    printf("%s: %f\n", "DGT_HUMIDITY_RAW", RawH);
    printf("%s: %f\n", "DGT_HUMIDITY_CAL_OFFSET", CalOffsetH);
    printf("%s: %f\n", "DGT_HUMIDITY_CAL_SLOPE", Hslope);
    printf("%s: %f\n", "DGT_HUMIDITY_CAL_T_SLOPE", TslopeH);
    printf("%s: %f\n", "DGT_LIGHT_RAW", RawL);

    ConvertRawTemperatureC(&TvalC, RawT);
    ConvertRawHumidity(&HvalPercentRH, RawH, CalOffsetH, Hslope, TslopeH, TvalC);
    ConvertRawLight(&LvalLux, RawL, TvalC, 1);

	// Print converted results
    TvalF = ReturnFfromC(TvalC);
    printf("%s: %f\n", "Temperature in celsius", TvalC);
	printf("%s: %f\n", "Temperature in fahrenheit", TvalF);
    printf("%s: %f\n", "Humidity in %RH", HvalPercentRH);
    printf("%s: %f\n", "Light in Lux", LvalLux);
    printf("\n");

	// Close
	err = LJM_Close(handle);
	ErrorCheck(err, "LJM_Close");

	WaitForUserIfWindows();

	return LJME_NOERROR;
}

void ConvertRawTemperatureC(double *TvalueC, double RawTemp)
{
    unsigned int TvalUnsigned = 0;

    TvalUnsigned = RawTemp;

    //Temperature is negative, MSB==1
    if ((TvalUnsigned) >= 32768)
    {
        TvalUnsigned = ((TvalUnsigned) - 1);
        TvalUnsigned = ~(TvalUnsigned);
        TvalUnsigned = ((TvalUnsigned) >> 4);
        TvalUnsigned = (TvalUnsigned) * (-1);
    }
    else //Temperature is positive, MSB==0
    {
        TvalUnsigned = ((TvalUnsigned) >> 4);
    }

    //Conversion factor 0.0625
    *TvalueC = ((TvalUnsigned) * 0.0625);
}

double ReturnFfromC(double degC)
{
    return(degC*1.8) + 32; //Convert to farhenheit
}

void ConvertRawHumidity(double *PercentRH, double RawCapacitance, double CalOffsetH, double Hslope, double TslopeH, double CurrentdegreesC)
{
    double ToffsetH = 0;
    double Tmin = -38;  //Minimum allowed temperature of Digit-TLH, per low-level documentation

    //%RH = (RawCapacitance - CalOffsetH + TOffsetH)(Hslope)
    //where...
    //ToffsetH = ((TslopeH)(Tcurrent)) - ((TslopeH)(Tmin))
    ToffsetH = (TslopeH * CurrentdegreesC) - (TslopeH * Tmin);
    *PercentRH = (RawCapacitance - CalOffsetH + ToffsetH) * Hslope;

}

void ConvertRawLight(double *Lux, double RawLight, double CurrentdegreesC, int OnUSBPower)
{
    int RoundedDegC = 0;
    int j = 0;
    int aMatchingLux[14] = {0};
    double aMatchingRaw[14] = {0};

    double fractionalIndex = 0;

    // Round current temperature to nearest degree Celsius, to allow for perfect match with 'aTempC[]' calibration values
    RoundedDegC = floor(CurrentdegreesC+0.5);

    //Reduce raw value by 35% due to 3.3V reg(USB), instead of 3.0V(battery).
    if (OnUSBPower != 0)
        RawLight = (RawLight * 0.65);

    // Create two arrays: Raw light readings and Lux, for a single temperature (the current temperature).  
    // This is how the 3D surface is simplifed, as discussed in the low-level docs 
    for(int i = 0; i < 1792; i++)
    {
        // Match found?
        if(aTempC[i] == RoundedDegC)
        {
            // Corresponding temperature slice found. There are always 14 slices. Use the 14 indices to make 2 simplified arrays
            aMatchingLux[j] = aLux[i];
            aMatchingRaw[j++] = aRawCounts[i];
        }
    }           

    // Linear interpolate. Generate a fractional index given the 1D array aRawCounts[] and a raw value, then 
    // use the fractional index on the 1D Lux array to get the interpolated Lux value.
    if (RawLight <= aMatchingRaw[0]) // outside of typical bounds, use lowest available raw value(Max Lux, 12000)
        *Lux = aMatchingLux[0];
    else if (RawLight >= aMatchingRaw[13]) // outside of typical bounds, use highest available raw value(Min Lux, 1)
        *Lux = aMatchingLux[13];
    else 
    {
        for(int k = 0; k < 14; k++)
        {
            if(aMatchingRaw[k] >= RawLight)
            {
                //k, and k-1 are the raw values that bracket the input value
                fractionalIndex = (RawLight - aMatchingRaw[k-1]) / (aMatchingRaw[k] - aMatchingRaw[k-1]);
                *Lux = Interpolate(aMatchingLux[k], aMatchingLux[k-1], fractionalIndex);
                break;
            }
        }
    }
}

inline double Interpolate(double a, double b, double coefficient)
{
    return (a + (coefficient * (b - a) ) );
}
